---
title: Terraform Support for Snippets · Changelog
description: Automate Snippet deployments with Terraform.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2024-12-11-terraform-snippets/
  md: https://developers.cloudflare.com/changelog/2024-12-11-terraform-snippets/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Terraform Support for Snippets

Dec 11, 2024

[Rules](https://developers.cloudflare.com/rules/)

Now, you can manage [Cloudflare Snippets](https://developers.cloudflare.com/rules/snippets/) with [Terraform](https://developers.cloudflare.com/terraform/). Use infrastructure-as-code to deploy and update Snippet code and rules without manual changes in the dashboard.

Example Terraform configuration:

```tf
resource "cloudflare_snippet" "my_snippet" {
  zone_id  = "<ZONE_ID>"
  name = "my_test_snippet_1"
  main_module = "file1.js"
  files {
    name = "file1.js"
    content = file("file1.js")
  }
}


resource "cloudflare_snippet_rules" "cookie_snippet_rule" {
  zone_id  = "<ZONE_ID>"
  rules {
    enabled = true
    expression = "http.cookie eq \"a=b\""
    description = "Trigger snippet on specific cookie"
    snippet_name = "my_test_snippet_1"
  }
  depends_on = [cloudflare_snippet.my_snippet]
}
```

Learn more in the [Configure Snippets using Terraform](https://developers.cloudflare.com/rules/snippets/create-terraform/) documentation.
