---
title: Build TanStack Start apps with the Cloudflare Vite plugin · Changelog
description: TanStack Start can now be used with the Cloudflare Vite plugin
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-10-24-tanstack-start/
  md: https://developers.cloudflare.com/changelog/2025-10-24-tanstack-start/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Build TanStack Start apps with the Cloudflare Vite plugin

Oct 24, 2025

[Workers](https://developers.cloudflare.com/workers/)

The [Cloudflare Vite plugin](https://developers.cloudflare.com/workers/vite-plugin/) now supports [TanStack Start](https://tanstack.com/start/) apps. Get started with new or existing projects.

#### New projects

Create a new TanStack Start project that uses the Cloudflare Vite plugin via the `create-cloudflare` CLI:

* npm

  ```sh
  npm create cloudflare@latest -- my-tanstack-start-app --framework=tanstack-start
  ```

* yarn

  ```sh
  yarn create cloudflare my-tanstack-start-app --framework=tanstack-start
  ```

* pnpm

  ```sh
  pnpm create cloudflare@latest my-tanstack-start-app --framework=tanstack-start
  ```

#### Existing projects

Migrate an existing TanStack Start project to use the Cloudflare Vite plugin:

1. Install `@cloudflare/vite-plugin` and `wrangler`

* npm

  ```sh
  npm i -D @cloudflare/vite-plugin wrangler
  ```

* yarn

  ```sh
  yarn add -D @cloudflare/vite-plugin wrangler
  ```

* pnpm

  ```sh
  pnpm add -D @cloudflare/vite-plugin wrangler
  ```

1. Add the Cloudflare plugin to your Vite config

```ts
import { defineConfig } from "vite";
import { tanstackStart } from "@tanstack/react-start/plugin/vite";
import viteReact from "@vitejs/plugin-react";
import { cloudflare } from "@cloudflare/vite-plugin";


export default defineConfig({
  plugins: [
    cloudflare({ viteEnvironment: { name: "ssr" } }),
    tanstackStart(),
    viteReact(),
  ],
});
```

1. Add your Worker config file

* wrangler.jsonc

  ```jsonc
  {
    "$schema": "./node_modules/wrangler/config-schema.json",
    "name": "my-tanstack-start-app",
    "compatibility_date": "2025-10-11",
    "compatibility_flags": [
      "nodejs_compat"
    ],
    "main": "@tanstack/react-start/server-entry"
  }
  ```

* wrangler.toml

  ```toml
  name = "my-tanstack-start-app"
  compatibility_date = "2025-10-11"
  compatibility_flags = ["nodejs_compat"]
  main = "@tanstack/react-start/server-entry"
  ```

1. Modify the scripts in your `package.json`

```json
{
  "scripts": {
    "dev": "vite dev",
    "build": "vite build && tsc --noEmit",
    "start": "node .output/server/index.mjs",
    "preview": "vite preview",
    "deploy": "npm run build && wrangler deploy",
    "cf-typegen": "wrangler types"
  }
}
```

See the [TanStack Start framework guide](https://developers.cloudflare.com/workers/framework-guides/web-apps/tanstack-start/) for more info.
