---
title: Enable Managed Rulesets · Cloudflare One docs
description: With managed rulesets, you can quickly deploy rules maintained by
  Cloudflare, and you can use Magic Firewall to control which rules are enabled.
lastUpdated: 2025-11-20T23:13:05.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/packet-filtering/enable-managed-rulesets/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/packet-filtering/enable-managed-rulesets/index.md
---

With [managed rulesets](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/), you can quickly deploy rules maintained by Cloudflare, and you can use Magic Firewall to control which rules are enabled.

Note:

Before you can begin using managed rulesets with Magic Firewall, your account must first be entitled to use managed rulesets. Contact your account team for access.

To enable or disable a rule, you can specify which properties should be overridden. The overrides occur in the Managed phase, root kind ruleset. Currently, you can only have one rule in the root ruleset, but a single rule can contain multiple overrides.

You have multiple options for enabling rules:

* Select an individual rule and enable it.
* Enable multiple rules by enabling by category in the `magic-transit-phase`.
* Enable an entire ruleset.

## API

### 1. Create a Managed phase Managed kind ruleset

To create a managed ruleset, you must first build a request with the following:

* `managed_ruleset_id`: The ID of the Managed phase Managed kind ruleset that contains the rule you want to enable.
* `managed_rule_id`: The ID of the rule you want to enable.

Additionally, you need the properties you want to override. The properties you can override include:

* `enabled`: This value can be set to `true` or `false`. When set to `true`, the rule matches packets and applies the rule's default action if the action is not overridden. When set to `false`, the rule is disabled and does not match any packets.
* `action`: The value can be set to `log` so the rule only produces logs instead of applying the rule's default action.

The `enabled` and `action` properties for a rule are set in the Managed phase Managed kind ruleset. All rules in the Managed phase are currently disabled by default.

The example below contains a request for a Managed phase Managed Kind ruleset.

```bash
curl https://api.cloudflare.com/client/v4/accounts/{account_id}/rulesets
--header "Authorization: Bearer <API_TOKEN>" \
--header "Content-Type: application/json" \
--data '{
  "name": "execute ruleset",
  "description": "Ruleset containing execute rules",
  "kind": "root",
  "phase": "magic_transit_managed",
  "rules": [
    {
      "expression": "true",
      "action": "execute",
      "description": "Enable one rule ",
      "action_parameters": {
        "id": "<MANAGED_RULESET_ID>",
        "version": "latest",
        "overrides": {
          "rules": [
            {
              "id": "<MANAGED_RULE_ID>",
              "enabled": true,
              "action": "log"
            }
          ]
        }
      }
    }
  ]
}'
```

### 2. Patch a Managed phase Managed kind ruleset

To ensure a root kind ruleset only contains one rule, patch the rule to enable new managed rules.

Building off the example from the previous step, the example below enables a category to select multiple rules instead of a single rule. The category will be set to `log` mode, which means the rule can produce logs but will not accept or drop packets.

```bash
curl --request PATCH \
https://api.cloudflare.com/client/v4/accounts/{account_id}/rulesets/{root_kind_ruleset}/rules/{root_kind_rule} \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Content-Type: application/json" \
--data '{
  "expression": "true",
  "action": "execute",
  "action_parameters": {
    "id": "<MANAGED_RULESET_ID>",
    "version": "latest",
    "overrides": {
      "rules": [
        {
          "id": "<MANAGED_RULE_ID>",
          "enabled": true
        }
      ],
      "categories": [
        {
          "category": "simple",
          "enabled": true,
          "action": "log"
        }
      ]
    }
  }
}'
```

### 3. Enable all rules

To enable the complete ruleset or enable all rules, send the request below.

```bash
curl --request PATCH \
https://api.cloudflare.com/client/v4/accounts/{account_id}{account_id}/rulesets/{root_kind_ruleset}/rules/{root_kind_rule} \
--header "Authorization: Bearer <API_TOKEN>" \
--header "Content-Type: application/json" \
--data '{
  "expression": "true",
  "action": "execute",
  "action_parameters": {
    "id": "<MANAGED_RULESET_ID>",
    "version": "latest",
    "overrides": {
      "enabled": true
    }
  }
}'
```

### 4. Delete a ruleset

To delete a ruleset, refer to [Delete a rule in a ruleset](https://developers.cloudflare.com/ruleset-engine/rulesets-api/delete-rule/).

## Cloudflare One dashboard

### Enable rules

You can also use the dashboard to enable managed rulesets:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Traffic policies** > **Firewall policies**.
2. Select **Packet filtering** and go to **Managed**. This is where the dashboard lists all your managed rules.
3. To enable a rule, turn **Status** on.

### Edit rules

To edit a rule:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Traffic policies** > **Firewall policies**.
2. Select **Packet filtering** and go to **Managed**. This is where the dashboard lists all your managed rules.
3. Select the three dots > **Edit**.
4. Make the necessary changes, then select **Save**.

### View rules

To view basic information about your rules:

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Traffic policies** > **Firewall policies**.
2. Select **Packet filtering** and go to **Managed**. This is where the dashboard lists all your managed rules.
3. Locate your managed rule, select the three dots > **View**.
