---
title: Frequently asked questions for DDoS Protection · Cloudflare DDoS
  Protection docs
description: When Cloudflare's DDoS systems detect and mitigate attacks, they
  drop, rate-limit, or challenge (as applicable) packets, DNS queries, or HTTP
  requests, based on the type of attack.
lastUpdated: 2025-08-19T15:06:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ddos-protection/frequently-asked-questions/
  md: https://developers.cloudflare.com/ddos-protection/frequently-asked-questions/index.md
---

## What is a DDoS attack event?

When Cloudflare's DDoS systems detect and mitigate attacks, they drop, rate-limit, or challenge (as applicable) packets, DNS queries, or HTTP requests, based on the type of attack.

There are three main DDoS mitigation systems:

1. [DDoS managed rulesets](https://developers.cloudflare.com/ddos-protection/managed-rulesets/)

   a. [Network-layer DDoS managed ruleset](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/)

   b. [HTTP DDoS managed ruleset](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/)

2. [Advanced TCP Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-tcp-protection/)

3. [Advanced DNS Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-dns-protection/)

The DDoS managed ruleset includes many individual rules. Each rule provides the heuristics that instructs the system how to identify DDoS attack traffic. When the DDoS managed ruleset identifies an attack, it will generate a real-time fingerprint to match against the attack traffic, and install an ephemeral mitigation rule to mitigate the attack using that fingerprint.

The start time of the attack is when the mitigation rule is installed. The attack ends when there is no more traffic matching the rule. This is a single DDoS attack event.

A DDoS attack has a start time, end time, and additional attack metadata such as:

* Attack ID
* Attack vector
* Mitigating rule
* Total bytes and packets
* Attack target
* Mitigation action

This information is used to populate the [Executive Summary](https://developers.cloudflare.com/analytics/network-analytics/understand/main-dashboard/#executive-summary) section in the [Network Analytics](https://developers.cloudflare.com/analytics/network-analytics/) dashboard.

It can also be retrieved via GraphQL API using the `dosdAttackAnalyticsGroups` node.

Currently, the concept of a DDoS attack event only exists for the [Network-layer DDoS managed ruleset](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/). There is no such grouping of individual packets, queries, or HTTP requests for the other systems yet.

***

## How does Cloudflare protect against "low and slow" DDoS attacks?

A [low and slow DDoS attack](https://www.cloudflare.com/learning/ddos/ddos-low-and-slow-attack/) is most commonly a non-volumetric attack. The attacker will send a low volume of HTTP requests, and do so slowly. This type of attack aims to be less detectable and slowly exhausts resources.

[Slowloris](https://www.cloudflare.com/learning/ddos/ddos-attack-tools/slowloris/) is a type of low and slow attack where the attacker establishes [TCP connections](https://developers.cloudflare.com/fundamentals/reference/tcp-connections/) to the target server, often using HTTP or HTTPS protocols.

In the case of a Slowloris attack, the attacker sends incomplete HTTP header lines, thus never completing the HTTP request. The server waits for the complete request, holding the connection open. The attacker periodically sends additional HTTP header fields or partial lines to keep the connection alive. This can be achieved by sending partial HTTP headers, or using the `content-length` header to declare a message body size larger than what is actually sent.

The best practice to defend against low and slow attacks is by using an HTTP reverse proxy, such as Cloudflare's [CDN](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/) or [WAF](https://developers.cloudflare.com/waf/) service. The reverse proxy acts as a shield. It waits for a full HTTP request before forwarding it to the origin, serving from cache, or applying other actions based on user configuration. If you are using our CDN/WAF services, our L7 reverse proxy will absorb low and slow attacks. It will buffer uploads at the edge by default. The proxy will wait for the full HTTP request before passing it on. The client requests must be completed.

The request will be served from Cloudflare's [Cache](https://developers.cloudflare.com/cache/) or [Workers](https://developers.cloudflare.com/workers/), if applicable. If not, it will only be sent to the origin — assuming it was fully completed and has passed WAF checks. So the attack does not exist, similar to TCP Slowloris attacks protection.

Additionally, the reverse proxy will timeout incomplete HTTP requests after a series of [keepalive probes](https://developers.cloudflare.com/fundamentals/reference/tcp-connections/#tcp-connections-and-keepalives).

There is not a minimum threshold for activation. However, to provide additional security, custom firewall rules check for payload sizes and conducts basic sanity checks to ensure the content looks like what is expected.

The RUDY (R-U-Dead-Yet?) DDoS attack is another type of denial-of-service (DoS) tool that performs slow-rate attacks on targeted servers.

Unlike conventional DDoS attacks that overwhelm servers with a high volume of requests in a short period, RUDY focuses on creating a few prolonged requests. It does this by submitting form data at an extremely slow pace to keep the web server tied up and unavailable to legitimate traffic. This approach makes RUDY attacks difficult to detect, because the traffic can appear legitimate and does not flood the server with requests that would typically trigger conventional DDoS protection mechanisms​​​​​​.

RUDY specifically targets the application layer (Layer 7) of web servers by exploiting the way web forms handle data submission. The attack works by injecting one byte of information into an application `POST` field at a time, then waiting. This process causes application threads to await the completion of the form submission indefinitely, effectively exhausting the server's resources and preventing it from processing legitimate requests​​​​.

Refer to the [learning center](https://www.cloudflare.com/learning/ddos/ddos-attack-tools/r-u-dead-yet-rudy/) for more information on RUDY attacks.

***

## How does Cloudflare deal with SSL/TLS negotiation attacks or floods?

SSL/TLS based attacks such as BEAST, Poodle, and CRIME are mitigated by Cloudflare's TLS settings, configuration, and cipher limitations. Because Cloudflare serves as the HTTP reverse proxy, TLS exhaustion style attacks are mitigated by terminating TLS sessions before passing HTTP requests to origin servers. TLS traffic is not proxied to origin servers without completing a proper TLS handshake. Additionally, our automated DDoS detection and mitigation systems leverage cipher suites, packet fields, HTTP request attributes and metadata, origin health, traffic profiling, Machine Learning models, and threat intelligence to detect and mitigate additional SSL-based attacks.

***

## Does Cloudflare use BGP Flowspec for upstream mitigation?

Yes. Using our anycast network, along with Traffic Manager, Unimog, and Plurimog, we conduct automated traffic engineering to spread the load of traffic (legitimate and attack) to ensure our network is performant, especially during mitigation of large attacks.

***

## Where can I see latest DDoS trends?

Cloudflare publishes quarterly DDoS reports and coverage of significant DDoS attacks. The publications are available on our [blog website](https://blog.cloudflare.com/tag/ddos-reports/) and as interactive reports on the [Cloudflare Radar Reports website](https://radar.cloudflare.com/reports?q=DDoS).

Learn more about the [methodologies](https://developers.cloudflare.com/radar/reference/quarterly-ddos-reports/) behind these reports.

You can also view [Cloudflare Radar](https://radar.cloudflare.com/) for near real-time insights and trends.

***

## What is the Ping of Death DDoS attacks?

The Ping of Death (PoD) attack involves sending malformed or oversized packets to another computer or server, which can cause the system to freeze, crash, or reboot. Packets are pieces of data sent over the Internet, and the Ping of Death takes advantage of the fact that the IP protocol requires packets to be a maximum of 65,535 bytes in size. By sending a packet larger than this size, the attacker can exploit vulnerabilities in the target's TCP/IP stack, causing a buffer overflow and leading to unpredictable behavior, including system crashes. This type of attack is less common nowadays, as most modern systems and networking equipment have been patched to handle such anomalies.

***

## What are LOIC and HOIC?

LOIC is a popular network stress testing and DoS attack application that is used to flood a server with TCP, UDP, or HTTP requests with the intention of disrupting the service. It is known for its simplicity and ability to be used by individuals with minimal hacking experience. LOIC can be directed by the user to attack a small server, which can cause the server to slow down or crash from the overload of requests. It became famous around 2010 for its use by the hacker group Anonymous in attacks against major companies and organizations.

HOIC is an upgrade from LOIC, designed to overcome some of its limitations, especially in terms of detection and mitigation. It allows users to launch a more powerful DoS attack by enabling attacks on multiple websites at the same time with a higher volume of requests. HOIC also incorporates a feature that makes it more difficult for defense mechanisms to identify and mitigate the attack traffic, partly because it uses a technique that allows the traffic to mimic legitimate HTTP traffic, which is more challenging for traditional network security tools to detect. HOIC supports the use of "booster" scripts that enable it to target various websites simultaneously, significantly increasing its potency as a tool for conducting broad-scale DoS attacks.

These tools and attacks exploit different aspects of network protocols and behaviors to overwhelm targets with unwanted traffic, leading to denial of service. Due to their potential for abuse, their use is illegal and unethical outside of controlled environments for testing purposes.

***

## Can I exclude specific user agents from HTTP DDoS protection?

Yes, you can create an [override](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/http-overrides/override-expressions/) and use the expression fields to match against HTTP requests with the user agent. There are a variety of [fields](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/http-overrides/override-expressions/#available-expression-fields) that you can use.

You can then adjust the [sensitivity level](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/override-parameters/#sensitivity-level) or [mitigation action](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/override-parameters/#action).

Refer to the guide on how to [create an override](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/http-overrides/configure-dashboard/#create-a-ddos-override).

The use of expression fields is subject to [availability](https://developers.cloudflare.com/ddos-protection/#availability).

***

## Does Cloudflare charge for DDoS attack traffic?

No. Since 2017, Cloudflare offers [free, unmetered, and unlimited DDoS protection](https://blog.cloudflare.com/unmetered-mitigation/). There is no limit to the number of DDoS attacks, their duration, or their size. Cloudflare's billing systems automatically exclude DDoS attack traffic from your usage.

***

## How does DDoS Protection determine whether a SYN flood attack is mitigated by `dosd` or Advanced TCP Protection?

DDoS [managed rules](https://developers.cloudflare.com/ddos-protection/managed-rulesets/) detect and mitigate attacks by finding commonality between attack packets and generating a real-time fingerprint to mitigate the attack.

When the attacks are highly randomized and DDoS managed rules are unable to detect a common pattern among the attack packets, [Advanced TCP Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-tcp-protection/) uses its stateful TCP flowtracking capabilities to determine whether or not packets are legitimate. Advanced TCP Protection also mitigates simpler TCP-based attacks.

Advanced TCP Protection is only necessary and available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers. For [Spectrum](https://developers.cloudflare.com/spectrum/) and our HTTP services, we leverage the reverse proxy to mitigate sophisticated randomized TCP-based DDoS attacks.

***

## How does Cloudflare handle hyper-localized DDoS attacks that may aim to overwhelm a specific Point of Presence (PoP)?

Hyper-localized DDoS attacks are attacks that target specific PoPs or data centers from botnet nodes that are close to those locations in an attempt to overwhelm them and cause an outage or service disruptions.

However, Cloudflare's defense approach is resilient to these attacks and uses a combination of intelligent traffic engineering, global Anycast, and real-time, autonomous DDoS mitigation to handle hyper-localized DDoS attacks — even those that may temporarily exceed the capacity of a specific Point of Presence (PoP).

### Global Anycast Network

Anycast allows multiple servers (PoPs) to share the same IP address, and the Border Gateway Protocol (BGP) routing system ensures user traffic is routed to the nearest or lowest-cost node.

#### Process

When one PoP is overwhelmed due to a local DDoS flood or as a result of limited capacity, BGP route propagation can be adjusted to shift traffic away from that PoP. Cloudflare can also withdraw BGP announcements from specific peers or upstreams to force traffic to reroute through better-equipped PoPs. Because DDoS traffic originates from multiple geographic regions, Anycast and traffic engineering distributes the attack across [Cloudflare's full capacity Anycast network](https://www.cloudflare.com/network/) to reduce the burden on a single PoP.

### Intelligent Traffic Engineering

Cloudflare uses real-time data and intelligence systems to make decisions about traffic routing, load balancing, and congestion management.

#### Process

If a specific PoP becomes saturated or experiences attack traffic, Cloudflare's internal traffic engineering systems dynamically steer traffic across alternative paths using traffic shaping, path-aware routing, and dynamic DNS responses.

The system monitors CPU load, network congestion, and traffic type to make smart decisions about whether to reroute or throttle connections.

For Layer 7 (application-level) attacks, Cloudflare can challenge or rate-limit traffic before it reaches application servers. This scenario is similar to some extent to when we take down certain PoPs for maintenance. This can be done automatically via Traffic Manager, and if needed, by our Site Reliability Engineers (SRE).

### Real-Time DDoS Mitigation

DDoS managed rules and Advanced DDoS Protection are autonomous and run on every single server independently, while also coordinating locally and globally, contributing to the resilience of each server and PoP. These systems run close to the network edge in every PoP, meaning detection and mitigation happen rapidly, often before any noticeable impact. If traffic exceeds the capacity of one PoP, mitigation rules are replicated to other PoPs to help absorb overflow.

* **DDoS managed rules**: Detects and mitigates DDoS attacks in real-time. When it detects an attack, it deploys rules within seconds to mitigate the malicious traffic.
* **Advanced TCP Protection**: Identifies and drops abnormal TCP/IP behavior before it hits application servers.
* **Advanced DNS Protection**: Identifies and drops abnormal DNS queries behavior before it hits DNS servers.

***

## What is Advanced TCP Protection's Protected Learning functionality?

The Protected Learning functionality enables the [Advanced TCP Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-tcp-protection/) system to overcome Internet routing chaos while allowing your legitimate traffic through and blocking DDoS attacks at the edge.

Anycast and BGP are protocols that help route Internet traffic by sending it to the nearest or most optimal data center. Occasional network events—such as a data center being taken offline for maintenance or changes in Internet routing—can cause an established connection to be rerouted to a different data center.

Cloudflare's flow inference functionality, also known as Protected Learning, is specifically designed to handle this. When a TCP connection, such as a flow, shifts to a new data center, our system observes that it is an existing connection that does not appear in the local flow table. Instead of immediately blocking the flow as an unknown connection that may be part of a DDoS attack, our system uses a proprietary process to verify if the connection is legitimate. It might challenge the acknowledgment (ACK) packets of the flow to ensure it is not part of a DDoS attack. Once the flow passes our checks, we allow it to continue without interruption. This ensures that even rare, legitimate shifts in traffic do not break your long-running connections while keeping your network protected against DDoS attacks.
