---
title: Zero Trust Network Session Logs · Cloudflare Logs docs
description: The descriptions below detail the fields available for
  zero_trust_network_sessions.
lastUpdated: 2025-08-12T16:39:17.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/zero_trust_network_sessions/
  md: https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/zero_trust_network_sessions/index.md
---

The descriptions below detail the fields available for `zero_trust_network_sessions`.

## AccountID

Type: `string`

Cloudflare account ID.

## BytesReceived

Type: `int`

The number of bytes sent from the origin to the client during the network session.

## BytesSent

Type: `int`

The number of bytes sent from the client to the origin during the network session.

## ClientTCPHandshakeDurationMs

Type: `int`

Duration of handshaking the TCP connection between the client and Cloudflare in milliseconds.

## ClientTLSCipher

Type: `string`

TLS cipher suite used in the connection between the client and Cloudflare.

## ClientTLSHandshakeDurationMs

Type: `int`

Duration of handshaking the TLS connection between the client and Cloudflare in milliseconds.

## ClientTLSVersion

Type: `string`

TLS protocol version used in the connection between the client and Cloudflare.

## ConnectionCloseReason

Type: `string`

The reason for closing the connection, only applicable for TCP.\
Possible values are *CLIENT\_CLOSED* | *CLIENT\_IDLE\_TIMEOUT* | *CLIENT\_TLS\_ERROR* | *CLIENT\_ERROR* | *ORIGIN\_CLOSED* | *ORIGIN\_TLS\_ERROR* | *ORIGIN\_ERROR* | *ORIGIN\_UNREACHABLE* | *ORIGIN\_UNROUTABLE* | *PROXY\_CONN\_REFUSED* | *UNKNOWN* | *MISMATCHED\_IP\_VERSIONS* | *TOO\_MANY\_ACTIVE\_SESSIONS\_FOR\_ACCOUNT* | *TOO\_MANY\_ACTIVE\_SESSIONS\_FOR\_USER* | *TOO\_MANY\_NEW\_SESSIONS\_FOR\_ACCOUNT* | *TOO\_MANY\_NEW\_SESSIONS\_FOR\_USER*.

## ConnectionReuse

Type: `bool`

Whether the TCP connection was reused for multiple HTTP requests.

## DestinationTunnelID

Type: `string`

Identifier of the Cloudflare One connector to which the network session was routed to, if any, such as Cloudflare Tunnel or WARP device.

## DetectedProtocol

Type: `string`

Detected traffic protocol of the network session.

## DeviceID

Type: `string`

Identifier of the client device which initiated the network session, if applicable, (for example, WARP Device ID).

## DeviceName

Type: `string`

Name of the client device which initiated the network session, if applicable, (for example, WARP Device ID).

## EgressColoName

Type: `string`

The name of the Cloudflare data center from which traffic egressed to the origin.

## EgressIP

Type: `string`

Source IP used when egressing traffic from Cloudflare to the origin.

## EgressPort

Type: `int`

Source port used when egressing traffic from Cloudflare to the origin.

## EgressRuleID

Type: `string`

Identifier of the egress rule that was applied by the Secure Web Gateway, if any.

## EgressRuleName

Type: `string`

The name of the egress rule that was applied by the Secure Web Gateway, if any.

## Email

Type: `string`

Email address associated with the user identity which initiated the network session.

## IngressColoName

Type: `string`

The name of the Cloudflare data center to which traffic ingressed.

## InitialOriginIP

Type: `string`

The IP used to correlate existing FQDN matching policy between Gateway DNS and Gateway proxy.

## Offramp

Type: `string`

The type of destination to which the network session was routed.\
Possible values are *INTERNET* | *MAGIC* | *CFD\_TUNNEL* | *WARP*.

## OriginIP

Type: `string`

The IP of the destination ("origin") for the network session.

## OriginPort

Type: `int`

The port of the destination origin for the network session.

## OriginTLSCertificateIssuer

Type: `string`

The issuer of the origin TLS certificate.

## OriginTLSCertificateValidationResult

Type: `string`

The result of validating the TLS certificate of the origin.\
Possible values are *VALID* | *EXPIRED* | *REVOKED* | *HOSTNAME\_MISMATCH* | *NONE* | *UNKNOWN*.

## OriginTLSCipher

Type: `string`

TLS cipher suite used in the connection between Cloudflare and the origin.

## OriginTLSHandshakeDurationMs

Type: `int`

Duration of handshaking the TLS connection between Cloudflare and the origin in milliseconds.

## OriginTLSVersion

Type: `string`

TLS protocol version used in the connection between Cloudflare and the origin.

## Protocol

Type: `string`

Network protocol used for this network session.\
Possible values are *TCP* | *UDP* | *ICMP* | *ICMPV6*.

## RegistrationID

Type: `string`

Identifier of the client registration which initiated the network session, if applicable (for example, WARP Registration ID).

## ResolvedFQDN

Type: `string`

The fully qualified domain name of the destination.

## RuleEvaluationDurationMs

Type: `int`

The duration taken by Secure Web Gateway applying applicable Network, HTTP, and Egress rules to the network session in milliseconds.

## SessionEndTime

Type: `int or string`

The network session end timestamp with nanosecond precision.

## SessionID

Type: `string`

The identifier of this network session.

## SessionStartTime

Type: `int or string`

The network session start timestamp with nanosecond precision.

## SourceIP

Type: `string`

Source IP of the network session.

## SourceInternalIP

Type: `string`

Local LAN IP of the device. Only available when connected via a GRE/IPsec tunnel on-ramp.

## SourcePort

Type: `int`

Source port of the network session.

## UserID

Type: `string`

User identity where the network session originated from. Only applicable for WARP device clients.

## VirtualNetworkID

Type: `string`

Identifier of the virtual network configured for the client.
