---
title: Rules examples · Cloudflare Rules docs
description: Explore the following examples for Rules.
lastUpdated: 2025-11-11T11:19:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/examples/
  md: https://developers.cloudflare.com/rules/examples/index.md
---

Explore the following examples for Rules.

Note

We have a separate listing for [Cache rules examples](https://developers.cloudflare.com/cache/how-to/cache-rules/examples/).

Filter resources...

[Route /images to an S3 Bucket using Terraform](https://developers.cloudflare.com/rules/cloud-connector/examples/route-images-to-aws-s3-using-terraform/)

[Route requests with a URI path starting with `/images` to a specific AWS S3 bucket with Cloud Connector using Terraform.](https://developers.cloudflare.com/rules/cloud-connector/examples/route-images-to-aws-s3-using-terraform/)

[Route /images to an S3 Bucket](https://developers.cloudflare.com/rules/cloud-connector/examples/route-images-to-s3/)

[Route requests with a URI path starting with `/images` to a specific AWS S3 bucket using Cloud Connector.](https://developers.cloudflare.com/rules/cloud-connector/examples/route-images-to-s3/)

[Send EU visitors to a Google Cloud Storage bucket](https://developers.cloudflare.com/rules/cloud-connector/examples/send-eu-visitors-to-gcs/)

[Route all traffic from EU visitors to a Google Cloud Storage bucket using Cloud Connector.](https://developers.cloudflare.com/rules/cloud-connector/examples/send-eu-visitors-to-gcs/)

[Serve /static-assets from Azure Blob Storage](https://developers.cloudflare.com/rules/cloud-connector/examples/serve-static-assets-from-azure/)

[Route requests with a URI path starting with `/static-assets` to an Azure Blob Storage container using Cloud Connector.](https://developers.cloudflare.com/rules/cloud-connector/examples/serve-static-assets-from-azure/)

[Disable Brotli compression](https://developers.cloudflare.com/rules/compression-rules/examples/disable-all-brotli/)

[Create a compression rule to turn off Brotli compression for all incoming requests of a given zone.](https://developers.cloudflare.com/rules/compression-rules/examples/disable-all-brotli/)

[Enable Zstandard compression for default content types](https://developers.cloudflare.com/rules/compression-rules/examples/enable-zstandard/)

[Create a compression rule to turn on Zstandard compression for response content types where Cloudflare applies compression by default.](https://developers.cloudflare.com/rules/compression-rules/examples/enable-zstandard/)

[Disable compression for AVIF images](https://developers.cloudflare.com/rules/compression-rules/examples/disable-compression-avif/)

[Create a compression rule to turn off compression for AVIF images, based on either the content type or the file extension specified in the request.](https://developers.cloudflare.com/rules/compression-rules/examples/disable-compression-avif/)

[Use Gzip compression for CSV files](https://developers.cloudflare.com/rules/compression-rules/examples/gzip-for-csv/)

[Create a compression rule to set Gzip compression as the preferred compression method for CSV files.](https://developers.cloudflare.com/rules/compression-rules/examples/gzip-for-csv/)

[Define a single configuration rule using Terraform](https://developers.cloudflare.com/rules/configuration-rules/examples/define-single-configuration-terraform/)

[Create a configuration rule using Terraform to turn off Email Obfuscation and Browser Integrity Check for API requests in a given zone.](https://developers.cloudflare.com/rules/configuration-rules/examples/define-single-configuration-terraform/)

[Use only Brotli compression for a specific path](https://developers.cloudflare.com/rules/compression-rules/examples/only-brotli-url-path/)

[Create a compression rule to set Brotli as the only supported compression algorithm for a specific URI path.](https://developers.cloudflare.com/rules/compression-rules/examples/only-brotli-url-path/)

[Change the HTTP Host header and DNS record](https://developers.cloudflare.com/rules/origin-rules/examples/change-http-host-header/)

[Create an origin rule to change the HTTP `Host` header and the resolved DNS record.](https://developers.cloudflare.com/rules/origin-rules/examples/change-http-host-header/)

[Change the destination port](https://developers.cloudflare.com/rules/origin-rules/examples/change-port/)

[Create an origin rule to change the destination port.](https://developers.cloudflare.com/rules/origin-rules/examples/change-port/)

[Define a single origin rule using Terraform](https://developers.cloudflare.com/rules/origin-rules/examples/define-single-origin-terraform/)

[Create an origin rule using Terraform to override the `Host` header, the resolved hostname, and the destination port of API requests.](https://developers.cloudflare.com/rules/origin-rules/examples/define-single-origin-terraform/)

[Add a request header with the current bot score](https://developers.cloudflare.com/rules/transform/examples/add-request-header-bot-score/)

[Create a request header transform rule to add a `X-Bot-Score` HTTP header to the request with the current bot score.](https://developers.cloudflare.com/rules/transform/examples/add-request-header-bot-score/)

[Add request header with a static value](https://developers.cloudflare.com/rules/transform/examples/add-request-header-static-value/)

[Create a request header transform rule to add an `X-Source` HTTP header to the request with a static value (`Cloudflare`).](https://developers.cloudflare.com/rules/transform/examples/add-request-header-static-value/)

[Add a request header for subrequests from other zones](https://developers.cloudflare.com/rules/transform/examples/add-request-header-subrequest-other-zone/)

[Create a request header transform rule to add an HTTP header when the Workers subrequest comes from a different zone.](https://developers.cloudflare.com/rules/transform/examples/add-request-header-subrequest-other-zone/)

[Add a response header with a static value](https://developers.cloudflare.com/rules/transform/examples/add-response-header-static-value/)

[Create a response header transform rule to add a `set-cookie` HTTP header to the response with a static value (`cookiename=value`).](https://developers.cloudflare.com/rules/transform/examples/add-response-header-static-value/)

[Normalize encoded slashes in URL path](https://developers.cloudflare.com/rules/transform/examples/normalize-encoded-slash/)

[Create a URL rewrite rule (part of Transform Rules) to normalize encoded forward slashes (`%2F`) in the request path to standard slashes (`/`).](https://developers.cloudflare.com/rules/transform/examples/normalize-encoded-slash/)

[Remove a request header](https://developers.cloudflare.com/rules/transform/examples/remove-request-header/)

[Create a request header transform rule (part of Transform Rules) to remove the `cf-connecting-ip` HTTP header from the request.](https://developers.cloudflare.com/rules/transform/examples/remove-request-header/)

[Remove a response header](https://developers.cloudflare.com/rules/transform/examples/remove-response-header/)

[Create a response header transform rule (part of Transform Rules) to remove the `cf-connecting-ip` HTTP header from the response.](https://developers.cloudflare.com/rules/transform/examples/remove-response-header/)

[Rewrite blog archive URLs](https://developers.cloudflare.com/rules/transform/examples/rewrite-archive-urls-new-format/)

[Create a transform rule to rewrite the URL format `/posts/<YYYY>-<MM>-<DD>-<TITLE>` to the new format `/posts/<YYYY>/<MM>/<DD>/<TITLE>`.](https://developers.cloudflare.com/rules/transform/examples/rewrite-archive-urls-new-format/)

[Rewrite path of moved section of a website](https://developers.cloudflare.com/rules/transform/examples/rewrite-moved-section/)

[Create a URL rewrite rule (part of Transform Rules) to rewrite everything under `/blog/<PATH>` to `/marketing/<PATH>`.](https://developers.cloudflare.com/rules/transform/examples/rewrite-moved-section/)

[Rewrite path of archived blog posts](https://developers.cloudflare.com/rules/transform/examples/rewrite-path-archived-posts/)

[Create a URL rewrite rule (part of Transform Rules) to rewrite any requests for `/news/2012/...` URI paths to `/archive/news/2012/...`.](https://developers.cloudflare.com/rules/transform/examples/rewrite-path-archived-posts/)

[Rewrite path for object storage bucket](https://developers.cloudflare.com/rules/transform/examples/rewrite-path-object-storage/)

[Create a URL rewrite rule (part of Transform Rules) to rewrite any requests for `/files/...` URI paths to `/...`.](https://developers.cloudflare.com/rules/transform/examples/rewrite-path-object-storage/)

[Rewrite image paths with several URL segments](https://developers.cloudflare.com/rules/transform/examples/rewrite-several-url-different-url/)

[Create a URL rewrite rule (part of Transform Rules) to rewrite any requests for `/images/<FOLDER1>/<FOLDER2>/<FILENAME>` to `/img/<FILENAME>`.](https://developers.cloudflare.com/rules/transform/examples/rewrite-several-url-different-url/)

[Rewrite URL query string](https://developers.cloudflare.com/rules/transform/examples/rewrite-url-string-visitors/)

[Create a transform rule to rewrite the request path from `/blog` to `/blog?sort-by=date`.](https://developers.cloudflare.com/rules/transform/examples/rewrite-url-string-visitors/)

[Set a response header with the current bot score](https://developers.cloudflare.com/rules/transform/examples/set-response-header-bot-score/)

[Create a response header transform rule (part of Transform Rules) to set an `X-Bot-Score` HTTP header in the response with the current bot score.](https://developers.cloudflare.com/rules/transform/examples/set-response-header-bot-score/)

[Rewrite page path for visitors in specific countries](https://developers.cloudflare.com/rules/transform/examples/rewrite-welcome-for-countries/)

[Create two URL rewrite rules (part of Transform Rules) to rewrite the path of the welcome page for visitors in specific countries.](https://developers.cloudflare.com/rules/transform/examples/rewrite-welcome-for-countries/)

[Set response header with a static value](https://developers.cloudflare.com/rules/transform/examples/set-response-header-static-value/)

[Create a response header transform rule (part of Transform Rules) to set an `X-Bot-Score` HTTP header in the response to a static value (`Cloudflare`).](https://developers.cloudflare.com/rules/transform/examples/set-response-header-static-value/)

[Append dates to cookies to use with A/B testing](https://developers.cloudflare.com/rules/snippets/examples/append-dates-to-cookies/)

[Dynamically set a cookie expiration and test group.](https://developers.cloudflare.com/rules/snippets/examples/append-dates-to-cookies/)

[Auth with headers](https://developers.cloudflare.com/rules/snippets/examples/auth-with-headers/)

[Allow or deny a request based on a known pre-shared key in a header. This is not meant to replace the WebCrypto API.](https://developers.cloudflare.com/rules/snippets/examples/auth-with-headers/)

[Send suspect bots to a honeypot](https://developers.cloudflare.com/rules/snippets/examples/bots-to-honeypot/)

[Use the bot score field to send bots to a honeypot.](https://developers.cloudflare.com/rules/snippets/examples/bots-to-honeypot/)

[Send Bot Management information to origin](https://developers.cloudflare.com/rules/snippets/examples/bot-data-to-origin/)

[Send Bots information to your origin. Refer to Bot Managenent variables for a full list of available fields.](https://developers.cloudflare.com/rules/snippets/examples/bot-data-to-origin/)

[A/B testing with same-URL direct access](https://developers.cloudflare.com/rules/snippets/examples/ab-testing-same-url/)

[Set up an A/B test by controlling what response is served based on cookies.](https://developers.cloudflare.com/rules/snippets/examples/ab-testing-same-url/)

[Bulk redirect based on a map object](https://developers.cloudflare.com/rules/snippets/examples/bulk-redirect-map/)

[Redirect requests to certain URLs based on a mapped object to the request's URL.](https://developers.cloudflare.com/rules/snippets/examples/bulk-redirect-map/)

[Country code redirect](https://developers.cloudflare.com/rules/snippets/examples/country-code-redirect/)

[Redirect a response based on the country code in the header of a visitor.](https://developers.cloudflare.com/rules/snippets/examples/country-code-redirect/)

[Custom cache](https://developers.cloudflare.com/rules/snippets/examples/custom-cache/)

[Store, retrieve, and remove assets from cache programmatically. Use this template to optimize performance and implement custom caching strategies.](https://developers.cloudflare.com/rules/snippets/examples/custom-cache/)

[Debugging logs](https://developers.cloudflare.com/rules/snippets/examples/debugging-logs/)

[Send debugging information in an errored response to a logging service.](https://developers.cloudflare.com/rules/snippets/examples/debugging-logs/)

[Define CORS headers](https://developers.cloudflare.com/rules/snippets/examples/define-cors-headers/)

[Adjust Cross-Origin Resource Sharing (CORS) headers and handle preflight requests.](https://developers.cloudflare.com/rules/snippets/examples/define-cors-headers/)

[Follow redirects from the origin](https://developers.cloudflare.com/rules/snippets/examples/follow-redirects/)

[Modify the fetch request to follow redirects from the origin, ensuring the client receives the final response.](https://developers.cloudflare.com/rules/snippets/examples/follow-redirects/)

[Add HEX timestamp to a request header](https://developers.cloudflare.com/rules/snippets/examples/hex-timestamp/)

[Add a custom header to requests sent to the origin server with the current timestamp in hexadecimal format for debugging, tracking, or custom routing purposes.](https://developers.cloudflare.com/rules/snippets/examples/hex-timestamp/)

[Validate JSON web tokens (JWT)](https://developers.cloudflare.com/rules/snippets/examples/jwt-validation/)

[Extract the JWT token from a header, decode it, and implement validation checks to verify it.](https://developers.cloudflare.com/rules/snippets/examples/jwt-validation/)

[Maintenance page](https://developers.cloudflare.com/rules/snippets/examples/maintenance/)

[Serve a custom maintenance page instead of fetching content from the origin server or cache. Ideal for downtime notifications, planned maintenance, or emergency messages.](https://developers.cloudflare.com/rules/snippets/examples/maintenance/)

[Override a Set-Cookie header with a certain value](https://developers.cloudflare.com/rules/snippets/examples/override-set-cookies-value/)

[Get a specific `Set-Cookie` header and update it with a certain value.](https://developers.cloudflare.com/rules/snippets/examples/override-set-cookies-value/)

[Redirect 403 Forbidden to a different page](https://developers.cloudflare.com/rules/snippets/examples/redirect-forbidden-status/)

[If origin responded with `403 Forbidden` error code, redirect to different page.](https://developers.cloudflare.com/rules/snippets/examples/redirect-forbidden-status/)

[Redirect from one domain to another](https://developers.cloudflare.com/rules/snippets/examples/redirect-replaced-domain/)

[Redirect all requests from one domain to another domain.](https://developers.cloudflare.com/rules/snippets/examples/redirect-replaced-domain/)

[Remove fields from API response](https://developers.cloudflare.com/rules/snippets/examples/remove-fields-api-response/)

[If origin responds with `JSON`, parse the response and delete fields to return a modified response.](https://developers.cloudflare.com/rules/snippets/examples/remove-fields-api-response/)

[Remove query strings before sending request to origin](https://developers.cloudflare.com/rules/snippets/examples/remove-query-strings/)

[Remove certain query strings from a request before passing to the origin.](https://developers.cloudflare.com/rules/snippets/examples/remove-query-strings/)

[Remove response headers](https://developers.cloudflare.com/rules/snippets/examples/remove-response-headers/)

[Remove from response all headers that start with a certain name.](https://developers.cloudflare.com/rules/snippets/examples/remove-response-headers/)

[Return information about the incoming request](https://developers.cloudflare.com/rules/snippets/examples/return-incoming-request-properties/)

[Respond with information about the incoming request provided by Cloudflare’s global network.](https://developers.cloudflare.com/rules/snippets/examples/return-incoming-request-properties/)

[Rewrite links on HTML pages](https://developers.cloudflare.com/rules/snippets/examples/rewrite-site-links/)

[Dynamically rewrite links in HTML responses. This is useful for site migrations and branding updates.](https://developers.cloudflare.com/rules/snippets/examples/rewrite-site-links/)

[Change origin and modify paths](https://developers.cloudflare.com/rules/snippets/examples/route-and-rewrite/)

[Route requests to a different origin, prepend a directory to the URL path, and remove specific segments.](https://developers.cloudflare.com/rules/snippets/examples/route-and-rewrite/)

[Set security headers](https://developers.cloudflare.com/rules/snippets/examples/security-headers/)

[Set common security headers such as X-XSS-Protection, X-Frame-Options, and X-Content-Type-Options.](https://developers.cloudflare.com/rules/snippets/examples/security-headers/)

[Send timestamp to origin as a custom header](https://developers.cloudflare.com/rules/snippets/examples/send-timestamp-to-origin/)

[Convert timestamp to hexadecimal format and send it as a custom header to the origin.](https://developers.cloudflare.com/rules/snippets/examples/send-timestamp-to-origin/)

[Route to a different origin based on origin response](https://developers.cloudflare.com/rules/snippets/examples/serve-different-origin/)

[If response to the original request is not `200 OK` or a redirect, send to another origin.](https://developers.cloudflare.com/rules/snippets/examples/serve-different-origin/)

[Sign requests](https://developers.cloudflare.com/rules/snippets/examples/signing-requests/)

[Verify a signed request using the HMAC and SHA-256 algorithms or return a 403.](https://developers.cloudflare.com/rules/snippets/examples/signing-requests/)

[Slow down suspicious requests](https://developers.cloudflare.com/rules/snippets/examples/slow-suspicious-requests/)

[Define a delay to be used when incoming requests match a rule you consider suspicious based on the bot score.](https://developers.cloudflare.com/rules/snippets/examples/slow-suspicious-requests/)

[Perform mobile redirects](https://developers.cloudflare.com/rules/url-forwarding/examples/perform-mobile-redirects/)

[Create a redirect rule to redirect visitors using mobile devices to a different hostname.](https://developers.cloudflare.com/rules/url-forwarding/examples/perform-mobile-redirects/)

[Redirect admin area requests to HTTPS](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-admin-https/)

[Create a redirect rule to redirect requests for the administration area of `store.example.com` to HTTPS, keeping the original path and query string.](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-admin-https/)

[Redirect requests from one domain to another](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-another-domain/)

[Create a redirect rule to redirect all requests to a different domain, maintaining all functionality, except for the discontinued HTTP service (port 80).](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-another-domain/)

[Redirect requests from one country to a domain](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-country/)

[Create a redirect rule to redirect all website visitors from the United Kingdom to a different domain, maintaining the current functionality in the same paths.](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-country/)

[Redirect requests for a domain to a new domain](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-different-domain-root/)

[Create a redirect rule to redirect all URLs for a domain to point to the root of a new domain, including any subdomains of the old domain.](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-different-domain-root/)

[Redirect local visitors to specific subdomains](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-country-subdomains/)

[Create a redirect rule to redirect United Kingdom and France visitors from the `example.com` website's root path (`/`) to their localized subdomains `https://gb.example.com` and `https://fr.example.com`, respectively.](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-country-subdomains/)

[Redirect requests to a different hostname](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-different-hostname/)

[Create a redirect rule to redirect all requests for `smallshop.example.com` to a different hostname using HTTPS, keeping the original path and query string.](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-all-different-hostname/)

[Redirect visitors to a new page URL](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-new-url/)

[Create a redirect rule to redirect visitors from `/contact-us/` to the page's new path `/contacts/`.](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-new-url/)

[Redirect from root to WWW](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-root-to-www/)

[Create a redirect rule to forward HTTPS requests from the root (also known as the “apex” or “naked” domain) to the WWW subdomain.](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-root-to-www/)

[Redirect from WWW to root](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-www-to-root/)

[Create a redirect rule to forward HTTPS requests from the WWW subdomain to the root (also known as the “apex” or “naked” domain).](https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-www-to-root/)

[Remove locale from URL path](https://developers.cloudflare.com/rules/url-forwarding/examples/remove-locale-url/)

[Create a redirect rule to redirect visitors from an old URL format with locale information to a new URL format.](https://developers.cloudflare.com/rules/url-forwarding/examples/remove-locale-url/)
