---
title: Snippets examples · Cloudflare Rules docs
description: Refer to the following examples to get started creating your snippet code.
lastUpdated: 2025-11-18T12:40:09.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/
  md: https://developers.cloudflare.com/rules/snippets/examples/index.md
---

Refer to the following examples to get started creating your snippet code.

Refer to [How Snippets work](https://developers.cloudflare.com/rules/snippets/how-it-works/) and [Create a snippet in the dashboard](https://developers.cloudflare.com/rules/snippets/create-dashboard/) for overall guidance.

Filter resources...

[Append dates to cookies to use with A/B testing](https://developers.cloudflare.com/rules/snippets/examples/append-dates-to-cookies/)

[Dynamically set a cookie expiration and test group.](https://developers.cloudflare.com/rules/snippets/examples/append-dates-to-cookies/)

[Auth with headers](https://developers.cloudflare.com/rules/snippets/examples/auth-with-headers/)

[Allow or deny a request based on a known pre-shared key in a header. This is not meant to replace the WebCrypto API.](https://developers.cloudflare.com/rules/snippets/examples/auth-with-headers/)

[Send suspect bots to a honeypot](https://developers.cloudflare.com/rules/snippets/examples/bots-to-honeypot/)

[Use the bot score field to send bots to a honeypot.](https://developers.cloudflare.com/rules/snippets/examples/bots-to-honeypot/)

[Send Bot Management information to origin](https://developers.cloudflare.com/rules/snippets/examples/bot-data-to-origin/)

[Send Bots information to your origin. Refer to Bot Managenent variables for a full list of available fields.](https://developers.cloudflare.com/rules/snippets/examples/bot-data-to-origin/)

[A/B testing with same-URL direct access](https://developers.cloudflare.com/rules/snippets/examples/ab-testing-same-url/)

[Set up an A/B test by controlling what response is served based on cookies.](https://developers.cloudflare.com/rules/snippets/examples/ab-testing-same-url/)

[Bulk redirect based on a map object](https://developers.cloudflare.com/rules/snippets/examples/bulk-redirect-map/)

[Redirect requests to certain URLs based on a mapped object to the request's URL.](https://developers.cloudflare.com/rules/snippets/examples/bulk-redirect-map/)

[Country code redirect](https://developers.cloudflare.com/rules/snippets/examples/country-code-redirect/)

[Redirect a response based on the country code in the header of a visitor.](https://developers.cloudflare.com/rules/snippets/examples/country-code-redirect/)

[Custom cache](https://developers.cloudflare.com/rules/snippets/examples/custom-cache/)

[Store, retrieve, and remove assets from cache programmatically. Use this template to optimize performance and implement custom caching strategies.](https://developers.cloudflare.com/rules/snippets/examples/custom-cache/)

[Debugging logs](https://developers.cloudflare.com/rules/snippets/examples/debugging-logs/)

[Send debugging information in an errored response to a logging service.](https://developers.cloudflare.com/rules/snippets/examples/debugging-logs/)

[Define CORS headers](https://developers.cloudflare.com/rules/snippets/examples/define-cors-headers/)

[Adjust Cross-Origin Resource Sharing (CORS) headers and handle preflight requests.](https://developers.cloudflare.com/rules/snippets/examples/define-cors-headers/)

[Follow redirects from the origin](https://developers.cloudflare.com/rules/snippets/examples/follow-redirects/)

[Modify the fetch request to follow redirects from the origin, ensuring the client receives the final response.](https://developers.cloudflare.com/rules/snippets/examples/follow-redirects/)

[Add HEX timestamp to a request header](https://developers.cloudflare.com/rules/snippets/examples/hex-timestamp/)

[Add a custom header to requests sent to the origin server with the current timestamp in hexadecimal format for debugging, tracking, or custom routing purposes.](https://developers.cloudflare.com/rules/snippets/examples/hex-timestamp/)

[Validate JSON web tokens (JWT)](https://developers.cloudflare.com/rules/snippets/examples/jwt-validation/)

[Extract the JWT token from a header, decode it, and implement validation checks to verify it.](https://developers.cloudflare.com/rules/snippets/examples/jwt-validation/)

[Maintenance page](https://developers.cloudflare.com/rules/snippets/examples/maintenance/)

[Serve a custom maintenance page instead of fetching content from the origin server or cache. Ideal for downtime notifications, planned maintenance, or emergency messages.](https://developers.cloudflare.com/rules/snippets/examples/maintenance/)

[Override a Set-Cookie header with a certain value](https://developers.cloudflare.com/rules/snippets/examples/override-set-cookies-value/)

[Get a specific `Set-Cookie` header and update it with a certain value.](https://developers.cloudflare.com/rules/snippets/examples/override-set-cookies-value/)

[Redirect 403 Forbidden to a different page](https://developers.cloudflare.com/rules/snippets/examples/redirect-forbidden-status/)

[If origin responded with `403 Forbidden` error code, redirect to different page.](https://developers.cloudflare.com/rules/snippets/examples/redirect-forbidden-status/)

[Redirect from one domain to another](https://developers.cloudflare.com/rules/snippets/examples/redirect-replaced-domain/)

[Redirect all requests from one domain to another domain.](https://developers.cloudflare.com/rules/snippets/examples/redirect-replaced-domain/)

[Remove fields from API response](https://developers.cloudflare.com/rules/snippets/examples/remove-fields-api-response/)

[If origin responds with `JSON`, parse the response and delete fields to return a modified response.](https://developers.cloudflare.com/rules/snippets/examples/remove-fields-api-response/)

[Remove query strings before sending request to origin](https://developers.cloudflare.com/rules/snippets/examples/remove-query-strings/)

[Remove certain query strings from a request before passing to the origin.](https://developers.cloudflare.com/rules/snippets/examples/remove-query-strings/)

[Remove response headers](https://developers.cloudflare.com/rules/snippets/examples/remove-response-headers/)

[Remove from response all headers that start with a certain name.](https://developers.cloudflare.com/rules/snippets/examples/remove-response-headers/)

[Return information about the incoming request](https://developers.cloudflare.com/rules/snippets/examples/return-incoming-request-properties/)

[Respond with information about the incoming request provided by Cloudflare’s global network.](https://developers.cloudflare.com/rules/snippets/examples/return-incoming-request-properties/)

[Rewrite links on HTML pages](https://developers.cloudflare.com/rules/snippets/examples/rewrite-site-links/)

[Dynamically rewrite links in HTML responses. This is useful for site migrations and branding updates.](https://developers.cloudflare.com/rules/snippets/examples/rewrite-site-links/)

[Change origin and modify paths](https://developers.cloudflare.com/rules/snippets/examples/route-and-rewrite/)

[Route requests to a different origin, prepend a directory to the URL path, and remove specific segments.](https://developers.cloudflare.com/rules/snippets/examples/route-and-rewrite/)

[Set security headers](https://developers.cloudflare.com/rules/snippets/examples/security-headers/)

[Set common security headers such as X-XSS-Protection, X-Frame-Options, and X-Content-Type-Options.](https://developers.cloudflare.com/rules/snippets/examples/security-headers/)

[Send timestamp to origin as a custom header](https://developers.cloudflare.com/rules/snippets/examples/send-timestamp-to-origin/)

[Convert timestamp to hexadecimal format and send it as a custom header to the origin.](https://developers.cloudflare.com/rules/snippets/examples/send-timestamp-to-origin/)

[Route to a different origin based on origin response](https://developers.cloudflare.com/rules/snippets/examples/serve-different-origin/)

[If response to the original request is not `200 OK` or a redirect, send to another origin.](https://developers.cloudflare.com/rules/snippets/examples/serve-different-origin/)

[Sign requests](https://developers.cloudflare.com/rules/snippets/examples/signing-requests/)

[Verify a signed request using the HMAC and SHA-256 algorithms or return a 403.](https://developers.cloudflare.com/rules/snippets/examples/signing-requests/)

[Slow down suspicious requests](https://developers.cloudflare.com/rules/snippets/examples/slow-suspicious-requests/)

[Define a delay to be used when incoming requests match a rule you consider suspicious based on the bot score.](https://developers.cloudflare.com/rules/snippets/examples/slow-suspicious-requests/)
