---
title: Sidebar · Cloudflare Style Guide
description: Configuring how folders and pages appear in the sidebar.
lastUpdated: 2024-10-04T16:22:18.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/frontmatter/sidebar/
  md: https://developers.cloudflare.com/style-guide/frontmatter/sidebar/index.md
---

## Labels

Labels are controlled by frontmatter properties on a given page, which vary depending on if you are configuring a group or a link.

### Links

In order of precedence:

1. `sidebar.label`
2. `title`

#### On an index page

Index page labels default to `Overview` if `sidebar.label` is not defined.

`title` is not taken into consideration due to `title` being used in group labelling.

### Groups

In order of precedence:

1. `sidebar.group.label`
2. `title`

### Example

For example, given the following pages:

```mdx
---
title: Bar
sidebar:
  label: IndexTitle
  group:
    label: GroupTitle
---
```

```mdx
---
title: Baz
sidebar:
  label: PageTitle
---
```

The sidebar structure will look like:

If we remove the `sidebar` property from both, it will now look like this:

## Ordering

Both links and groups use the `sidebar.order` frontmatter property to configure their ordering, where groups are ordered based on the index page's order.

If `sidebar.order` is not specified, it will fallback to alphabetical ordering.

For example, given the following pages:

```mdx
---
title: Alpha
sidebar:
  order: 3
---
```

```mdx
---
title: Beta
sidebar:
  order: 2
---
```

The sidebar structure will look like:

If we remove the `sidebar` property from both, it will now look like this:

## Hiding pages

There are three properties that can be used for hiding pages from the sidebar.

### Hiding individual pages

#### `hidden`

This property should only be used when the page is **not** an index page for a group.

```mdx
---
title: Placeholder
sidebar:
  hidden: true
---
```

#### `group.hideIndex`

Since index pages are relied on to configure the label and sort order of groups, we have a special property that still makes the page available to our sidebar component and allows us to remove it after labelling and ordering groups.

```mdx
---
title: Placeholder
sidebar:
  group:
    hideIndex: true
---


import { DirectoryListing } from "~/components";


<DirectoryListing />
```

Note

Since these pages are still accessible via other links and directly navigating to the URL, always include a `DirectoryListing` component within the page content.

### Hiding child pages of a group

To make a group render as if it was a single page, which links to the index page, use the top-level `hideChildren` property.

## Badges

### Links

To specify a badge next to the link, use the `sidebar.badge` property.

```mdx
---
title: Example
sidebar:
  badge: New!
---
```

### Groups

To specify a badge next to the group label, use the `sidebar.group.badge` inside the group's `index.mdx` frontmatter.

```mdx
---
title: Examples
sidebar:
  group:
    badge: New!
---
```
