---
title: Migrate from reCAPTCHA · Cloudflare Turnstile docs
description: If you are using reCAPTCHA today, you can switch seamlessly to
  Cloudflare Turnstile by following the step-by-step guide below to assist with
  the upgrade process.
lastUpdated: 2025-09-04T15:24:34.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/turnstile/migration/recaptcha/
  md: https://developers.cloudflare.com/turnstile/migration/recaptcha/index.md
---

If you are using reCAPTCHA today, you can switch seamlessly to Cloudflare Turnstile by following the step-by-step guide below to assist with the upgrade process.

To complete the migration, you must obtain the [sitekey and secret key](https://developers.cloudflare.com/turnstile/get-started/#get-a-sitekey-and-secret-key).

Note

Turnstile migration is currently compatible up to reCAPTCHA v2.

## Client-side integration

1. Update the client-side integration by inserting the Turnstile script snippet in your HTML's `<head>` element.

   ```html
   <script src="https://challenges.cloudflare.com/turnstile/v0/api.js?compat=recaptcha" async defer></script>
   ```

   Note

   Adding `?compat=recaptcha` runs Turnstile in compatibility mode, which enables the following features:

   * implicit rendering for reCAPTCHA
   * `g-recaptcha-response` input name for forms
   * register the Turnstile API as `grecaptcha`

2. Locate the `grecaptcha.render()` calls and replace the sitekey with your Turnstile sitekey.

   Note

   Turnstile supports:

   * the `render()` call
   * reCAPTCHA v2 invisible mode with the `execute()` call

## Server-side integration

Update the server-side integration by replacing the Siteverify URL.

Replace `https://www.google.com/recaptcha/api/siteverify` with the following:

```txt
https://challenges.cloudflare.com/turnstile/v0/siteverify
```

Differences to reCAPTCHA's Siteverify

reCAPTCHA supports `GET` requests using query parameters, such as `GET /siteverify?response=<response>&secret=<secret>`.

Turnstile's Siteverify endpoint does *not* support this and only accepts `POST` requests with a FormData or JSON body.

Refer to [server-side validation](https://developers.cloudflare.com/turnstile/get-started/server-side-validation/) for more information.
