---
title: Historical (2020) · Cloudflare Web Application Firewall (WAF) docs
description: Changes to WAF managed rulesets done in 2020.
lastUpdated: 2025-02-18T19:39:49.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/change-log/historical-2020/
  md: https://developers.cloudflare.com/waf/change-log/historical-2020/index.md
---

| Ruleset | Rule ID | Description | Change Date | Old Action | New Action |
| - | - | - | - | - | - |
| Cloudflare Drupal | D0025 | CVE:CVE-2020-13671 | 2020-12-14 | N/A | Block |
| Cloudflare Specials | 100048 | Improve body anomaly detection | 2020-12-02 | Disable | Disable |
| Cloudflare Specials | 100502 | CVE:CVE-2020-13443 | 2020-11-16 | N/A | Block |
| Cloudflare WordPress | WP0017 | WordPress - SQLi - CVE:CVE-2015-2213 fix | 2020-11-16 | Block | Block |
| Cloudflare Specials | 100501 | Oracle WebLogic - Deserialization - CVE:CVE-2020-14882, CVE:CVE-2020-14883, CVE:CVE-2020-14750 | Emergency, 2020-11-05 | N/A | Block |
| Cloudflare Specials | 100164 | SaltStack - Command Injection - CVE-2020-16846 | Emergency, 2020-11-04 | N/A | Block |
| Cloudflare Specials | 100164\_JSON | SaltStack - Command Injection - CVE-2020-16846 | Emergency, 2020-11-04 | N/A | Block |
| Cloudflare Specials | 100164\_YAML | SaltStack - Command Injection - CVE-2020-16846 | Emergency, 2020-11-04 | N/A | Block |
| Cloudflare Specials | 100124 | Improve Command Injection detection | 2020-10-19 | Disabled | Disabled |
| Cloudflare Specials | 100175 | Anomaly:Header:X-Up-Devcap-Post-Charset - Evasion | 2020-10-12 | N/A | Block |
| Cloudflare Specials | 100500 | October CMS - File Inclusion | 2020-10-12 | N/A | Block |
| Cloudflare Specials | 100600 | Improve XSS detection | 2020-10-05 | N/A | Block |
| Cloudflare Specials | 100016 | Improve Information Disclosure detection | 2020-09-28 | Block | Block |
| Cloudflare WordPress | 100189 | WordPress - Command Injection | 2020-09-21 | Log | Block |
| Cloudflare Specials | 100131 | Improve JSFuck XSS detection. Merges 100131\_BETA into 100131. | 2020-09-21 | Disabled | Block |
| Cloudflare Specials | 100131\_BETA | XSS - JSFuck | 2020-09-15 | N/A | Log |
| Cloudflare Specials | 100173 | Improve XSS detection | 2020-09-07 | Block | Block |
| Cloudflare Specials | 100304 | Improve performance | 2020-09-07 | Disabled | Disabled |
| Cloudflare Specials | 100455 | XSS - Catch Injection | 2020-09-07 | N/A | Block |
| Cloudflare Specials | 100065 | Anomaly:URL:Query String - Relative Paths | 2020-09-01 | N/A | Disabled |
| Cloudflare Specials | 100166 | vBulletin - Code Injection - CVE:CVE-2019-16759 | 2020-08-24 | Block | Block |
| Cloudflare WordPress | WP0025B | Improve performance | 2020-08-03 | Block | Block |
| Cloudflare Specials | 100045 | Anomaly:URL - Multiple Slashes, Relative Paths, CR, LF or NULL | 2020-08-03 | Disable | Disable |
| Cloudflare Specials | 100315 | RCE in BIG-IP Traffic Management User Interface - CVE:CVE-2020-5902 | 2020-08-03 | Block | Block |
| Cloudflare Miscellaneous | 100317 | vBulletin - SQLi - CVE:CVE-2020-12720 | 2020-07-27 | N/A | Block |
| Cloudflare Specials | 100139D | XSS | 2020-07-27 | Block | Block |
| Cloudflare Specials | 100318 | Anomaly:Method - Unknown HTTP Method | 2020-07-20 | N/A | Disable |
| Cloudflare Specials | 100319 | Anomaly:Method - Unusual HTTP Method | 2020-07-20 | N/A | Disable |
| Cloudflare Specials | 100031 | Improve performance | 2020-07-13 | Block | Block |
| Cloudflare Specials | 100071 | Improve performance | 2020-07-13 | Disable | Disable |
| Cloudflare Specials | 100315 | RCE in BIG-IP Traffic Management User Interface - CVE:CVE-2020-5902 | Emergency, 2020-07-07 | N/A | Block |
| Cloudflare Specials | 100310 | Improve Apache Struts code injection detection | 2020-06-22 | Block | Block |
| Cloudflare Specials | 100135A | Improve XSS detection | 2020-06-15 | Block | Block |
| Cloudflare Specials | 100135B | Improve XSS detection | 2020-06-15 | Block | Block |
| Cloudflare Specials | 100135C | Improve XSS detection | 2020-06-15 | Block | Block |
| Cloudflare Specials | 100136A | Improve XSS detection | 2020-06-15 | Block | Block |
| Cloudflare Specials | 100136B | Improve XSS detection | 2020-06-15 | Block | Block |
| Cloudflare Specials | 100136C | Improve XSS detection | 2020-06-15 | Block | Block |
| Cloudflare Specials | 100045 | Improve URL anomaly detection | 2020-06-15 | Challenge | Disable |
| Cloudflare Misc | 100075 | Block HULK DoS | 2020-06-08 | Disable | Disable |
| Cloudflare Specials | 100307 | Improve XSS detection | 2020-06-08 | Block | Block |
| Cloudflare Specials | 100174 | XSS - JS Context Escape | 2020-05-25 | Block | Block |
| Cloudflare Specials | 100008C | Sleep Function | 2020-05-11 | Block | Block |
| Cloudflare Specials | 100307 | jQuery URI XSS | 2020-05-11 | N/A | Block |
| Cloudflare Specials | 100303 | Command Injection - Nslookup | 2020-05-11 | Disabled | Disabled |
| Cloudflare Specials | 100124 | Command Injection - Nslookup | 2020-05-11 | Disabled | Disabled |
| Cloudflare Specials | 100303 | Nslookup | 2020-05-04 | N/A | Disable |
| Cloudflare Specials | 100304 | Server-Side Includes | 2020-05-04 | N/A | Disable |
| Cloudflare Specials | 100124 | Sleep | 2020-05-04 | N/A | Disable |
| Cloudflare Specials | 100008 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100008E | Improve performance | 2020-04-27 | N/A | Block |
| Cloudflare Specials | 100008CW | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100008D | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100158 | Improve performance | 2020-04-27 | N/A | Block |
| Cloudflare Specials | 100106 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100106B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100140 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100089 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100162 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100026 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100018 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100018B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100232 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100005 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100135A | Improve XSS detection, false positive rate and performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100135B | Improve XSS detection, false positive rate and performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100135C | Improve XSS detection, false positive rate and performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100136A | Improve XSS detection, false positive rate and performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100136B | Improve XSS detection, false positive rate and performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100136C | Improve XSS detection, false positive rate and performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100167 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100168 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100169 | Improve performance | 2020-04-27 | Disable | Disable |
| Cloudflare Specials | 100170 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100171 | Improve performance | 2020-04-27 | Disable | Disable |
| Cloudflare Specials | 100172 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100173 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100174 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100221 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100222 | Improve HTML Injection detection and performance | 2020-04-27 | Disable | Disable |
| Cloudflare Specials | 100156 | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100139A | Improve performance | 2020-04-27 | Disable | Disable |
| Cloudflare Specials | 100139B | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100139C | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Specials | 100139D | Improve performance | 2020-04-27 | Block | Block |
| Cloudflare Magento | MG0003B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Drupal | D0013 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Drupal | D0014 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Drupal | D0001 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare PHP | PHP100004 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare PHP | PHP100008 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare PHP | PHP100009 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare PHP | PHP100010 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Miscellaneous | CFMISC0001 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Miscellaneous | CFMISC0002 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Miscellaneous | CFMISC0003 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Miscellaneous | CFMISC0010 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Miscellaneous | CFMISC0011 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WHMCS | WHMCS0001 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WHMCS | WHMCS0002 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WHMCS | WHMCS0003 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | 900044 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | 900122 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | 900123 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | 900124 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | 900125 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | 900126 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | 900127 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | 999003 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | 100000 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | WP0001 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | WP0005 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | WP0006 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | WP0007 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | WP0015 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare WordPress | WP0018 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100002 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100002A | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100005A | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100105HEADERS | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100105 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100116 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100109B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100006 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100007B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100009C | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100009EP | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100009EP | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100009EF | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100009L | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100010C | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100014B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100017 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100020 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100032 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100039B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100046 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100052B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100056 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100057 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100058 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100060 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100064 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100066 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100067 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100068 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100068B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100074 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100076 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100077B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100078 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100078B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100082 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100086 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100086B | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100088 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100088C | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100095 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100097 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100099 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100100 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100104 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100108ARGS | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100109 | Deprecated | 2020-04-27 | N/A | Disable |
| Cloudflare Specials | 100310 | Apache Struts code injection | 2020-04-27 | N/A | Block |
| Cloudflare Specials | 100305 | ASP.NET - Deserialization - CVE:CVE-2019-18935 | 2020-04-20 | N/A | Disable |
| Cloudflare Specials | 100306 | Improve SQLi detection | 2020-04-20 | N/A | Block |
| Cloudflare PHP | PHP100011ARGS | Deprecated | 2020-04-20 | N/A | Disable |
| Cloudflare PHP | PHP100011COOKIE | Deprecated | 2020-04-20 | N/A | Disable |
| Cloudflare Specials | 100135A | Improve XSS detection. Merge 100135A\_BETA into 100135A. | 2020-04-06 | Block | Block |
| Cloudflare Specials | 100136A | Improve XSS detection. Merge 100136A\_BETA into 100136A. | 2020-04-06 | Block | Block |
| Cloudflare Specials | 100301 | SQLi detection improvement on `TRUNCATE`-like statements | 2020-03-30 | Block | Block |
| Cloudflare Specials | 100300 | Improve SQL Operators support to prevent SQL Injection | 2020-03-23 | N/A | Block |
| Cloudflare Specials | 100302 | SQLi detection improvement on for `UNION`-like statements | 2020-03-23 | N/A | Block |
| Cloudflare Specials | 100135B | Improve XSS detection. Merge 100135B\_BETA into 100135B. | 2020-03-23 | Block | Block |
| Cloudflare Specials | 100136B | Improve XSS detection. Merge 100136B\_BETA into 100136B. | 2020-03-23 | Block | Block |
| N/A | N/A | Logging for rules in the OWASP rule group has been improved by removing duplicate and empty log events. | 2020-03-12 | N/A | N/A |
| Cloudflare Specials | 100162 | SQLi improvement on `SELECT FROM TABLE` statements | 2020-03-09 | Block | Block |
| Cloudflare Specials | 100201 | Improve Fake Google Bot detection | Emergency release, 2020-03-02 | Block | Block |
| Cloudflare Specials | 100005 | Improve File Inclusion detection | Emergency release, 2020-03-02 | Block | Block |
| Cloudflare Specials | 100007NS | Improve Command Injection detection | Emergency release, 2020-03-02 | Block | Block |
| Cloudflare Specials | 100049A | Improve GraphicsMagick, ImageMagick attack detection. Merge 100049A\_BETA into 100049A. | 2020-02-17 | Block | Block |
| Cloudflare Specials | 100220 | Improve XSS detection. Merge 100220\_BETA into 100220. | 2020-02-10 | Disable | Disable |
| Cloudflare Specials | 100221 | Improve XSS detection. Merge 100221\_BETA into 100221. | 2020-02-10 | Disable | Disable |
| Cloudflare Specials | 100024 | Deprecated | 2020-02-10 | Block | Disable |
| Cloudflare Specials | 100042 | Deprecated | 2020-02-10 | Disable | Disable |
| Cloudflare Specials | 100112B | Deprecated | 2020-02-10 | Disable | Disable |
| Cloudflare Specials | 100029 | Deprecated | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100043 | Deprecated | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100047WP | Deprecated | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100012 | Deprecated | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100013 | Superseded by 100220, 100221 | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100050 | Deprecated | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100051 | Deprecated | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100034 | Deprecated | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100028 | Deprecated | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100014 | Deprecated | 2020-01-27 | Disable | Disable |
| Cloudflare Specials | 100186 | Superseded by 100026 | 2020-01-27 | Block | Disable |
| Cloudflare Specials | 100038 | Reduce false positive rate. Merge 100038\_BETA into 100038. | 2020-01-27 | Block | Block |
| Cloudflare Specials | 100043A | Improve performance. Merge 100043A\_BETA into 100043A. | 2020-01-27 | N/A | Block |
| Cloudflare Specials | 100043B | Improve performance. Merge 100043B\_BETA into 100043B. | 2020-01-27 | N/A | Block |
| Cloudflare Specials | 100243 | Improve Joomla SQLi detection | 2020-01-27 | N/A | Block |
| Cloudflare Specials | 100244 | Improve Adobe Flash attack detection | 2020-01-27 | N/A | Block |
| Cloudflare Specials | 100245 | Improve WordPress Broken Access Control Update Script detection | 2020-01-27 | N/A | Block |
| Cloudflare Specials | 100246 | Improve WordPress EWWW Image Optimizer Command Injection detection | 2020-01-27 | N/A | Block |
| Cloudflare Specials | 100247 | Improve WordPress API validation | 2020-01-27 | N/A | Block |
| Cloudflare Flash | F0001 | Superseded by 100244 | 2020-01-27 | Challenge | Disable |
| Cloudflare Flash | F0002 | Superseded by 100244 | 2020-01-27 | Challenge | Disable |
| Cloudflare Specials | 100201 | Block fake Google bots | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100202 | Block fake Bing and MSN bots | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100203 | Block fake Yandex bots | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100204 | Block fake Baidu bots | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100035D | Superseded by 100201 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100035 | Superseded by 100201 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100035C | Superseded by 100201 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100035B | Superseded by 100202 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100035Y | Superseded by 100203 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100035U | Superseded by 100204 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100037 | Superseded by 100204 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100112 | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | WP0029 | Improve performance. Merge WP0029\_BETA into WP0029. | 2020-01-20 | Block | Block |
| Cloudflare Specials | WP0011 | Improve performance. Superseded by 100233. | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100233 | Improve performance | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100220 | Improve XSS and HTML Injection detection | 2020-01-20 | N/A | Disable |
| Cloudflare Specials | 100221 | Improve XSS and HTML Injection detection in request bodies | 2020-01-20 | N/A | Disable |
| Cloudflare Specials | 100096BASE | Superseded by 100220 | 2020-01-20 | N/A | Disable |
| Cloudflare Specials | 100096HTML | Superseded by 100220 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100096EVIL | Superseded by 100220 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100096BBASE | Superseded by 100220 | 2020-01-20 | N/A | Disable |
| Cloudflare Specials | 100096BHTML | Superseded by 100220 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100096BEVIL | Superseded by 100220 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100016 | Improve performance. Merge 100016\_BETA into 100016. | 2020-01-20 | Block | Block |
| Cloudflare Specials | 100018 | Improve performance. Merge 100018\_BETA into 100018. | 2020-01-20 | Block | Block |
| Cloudflare Specials | 100018B | Improve performance. Merge 100018B\_BETA into 100018B. | 2020-01-20 | Block | Block |
| Cloudflare Specials | 100025 | Deprecated | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100089 | Improve performance. Merge 100089\_BETA into 100089. | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100112 | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100115 | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100117 | Superseded by 100026 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100120C | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100121ARGS\_GET | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100121URI | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100122 | Superseded by 100232 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100122ARGS | Superseded by 100232 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100122ARGS\_GET | Superseded by 100232 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100132 | Improve performance. Merge 100132\_BETA into 100132 | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100155 | Improve performance. Merge 100155\_BETA into 100155. | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100230 | Improve Drupal Command Injection detection | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100198 | Improve Apache Struts Code Injection detection | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100199 | Improve Drupal Command Injection detection | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100231 | Improve PHP Deserialization detection | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100232 | Improve Code Injection, Deserialization with Stream Wrapper detection | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100234 | Improve WordPress Broken Access Control detection | 2020-01-20 | N/A | Block |
| Cloudflare Specials | 100084 | Superseded by 100170 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100030SVG | Superseded by 100135A, 100135B, 100135C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021C | Superseded by 100135A, 100135B, 100135C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021CE | Superseded by 100135A, 100135B, 100135C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021CB | Superseded by 100135A, 100135B, 100135C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021CD | Superseded by 100135A, 100135B, 100135C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021CD2 | Superseded by 100135A, 100135B, 100135C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021CD3 | Superseded by 100135A, 100135B, 100135C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021D | Superseded by 100136A, 100136B, 100136C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100107 | Superseded by 100136A, 100136B, 100136C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100107ARGS | Superseded by 100136A, 100136B, 100136C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100148 | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100149 | Superseded by 100136A, 100136B, 100136C | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100030 | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100030ARGS\_STRICT | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100030ARGS\_LOOSE | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021 | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021B | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021E | Superseded by 100139D | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021E | Superseded by 100139D | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100090 | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100091 | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100091B | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100092 | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100093 | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100133 | Superseded by 100173 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100137 | Superseded by 100174 | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100021H | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100113 | Deprecated | 2020-01-20 | Block | Disable |
| Cloudflare Specials | 100120C | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100120C | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Specials | 100112 | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare PHP | PHP100002 | Superseded by 100232 | 2020-01-20 | Disable | Disable |
| Cloudflare Miscellaneous | CFMISC0004 | Superseded by 100198 | 2020-01-20 | Disable | Disable |
| Cloudflare Miscellaneous | CFMISC0005 | Deprecated | 2020-01-20 | Disable | Disable |
| Cloudflare Miscellaneous | CFMISC0011 | Improve performance | 2020-01-20 | Block | Block |
| Cloudflare Miscellaneous | CFMISC0014 | Superseded by 100199 | 2020-01-20 | Block | Disable |
| Cloudflare Miscellaneous | CFMISC0014B | Superseded by 100199 | 2020-01-20 | Block | Disable |
| Cloudflare Miscellaneous | CFMISC0015 | Superseded by 100199 | 2020-01-20 | Block | Disable |
| Cloudflare Miscellaneous | CFMISC0016 | Superseded by 100199 | 2020-01-20 | Block | Disable |
| Cloudflare Miscellaneous | CFMISC0016B | Superseded by 100199 | 2020-01-20 | Block | Disable |
| Cloudflare Miscellaneous | CFMISC0017 | Superseded by 100199 | 2020-01-20 | Block | Disable |
| Cloudflare Drupal | D0016 | Superseded by 100232 | 2020-01-20 | Disable | Disable |
| Cloudflare Drupal | D0004 | Superseded by 100230 | 2020-01-20 | Block | Disable |
| Cloudflare Drupal | D0004B | Superseded by 100230 | 2020-01-20 | Block | Disable |
| Cloudflare Drupal | D0004C | Superseded by 100230 | 2020-01-20 | Block | Disable |
| Cloudflare Drupal | D0020 | Superseded by 100231 | 2020-01-20 | Block | Disable |
| Cloudflare Magento | MG0003A | Superseded by 100231 | 2020-01-20 | Block | Disable |
| OWASP | 960034 | Deprecated | 2020-01-20 | N/A | N/A |
